<?php namespace Visiosoft\OrdersModule\Orderdetail\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\UsersModule\User\UserRepository;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\OptionConfiguration\Contract\OptionConfigurationRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailRepository;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\User\UserModel;
use Visiosoft\DopingsModule\Doping\DopingModel;

class OrderdetailTableColumns
{
    public function handle(OrderdetailTableBuilder $builder)
    {
        $builder->setColumns([
            'item_id' => [
                'value' => function (EntryInterface $entry,
                                     AdvRepositoryInterface $repository,
                                     OrderdetailRepository $orderdetailRepository,
                                     OptionConfigurationRepositoryInterface $optionConfigurationRepository) {
                    $isActive = new AdvModel();
                    $isActivePackages = $isActive->is_enabled('packages');
                    $isDopingsActive = $isActive->is_enabled('dopings');
                    if ($entry->item_type == 'adv') {
                        $adv = $repository->getListItemAdv($entry->item_id);
                        $status = $orderdetailRepository->getStatus($entry->id);
                        if ($adv) {
                            return '<a href="' . route("adv_detail", [$adv->id]) . '">' . $adv->id . '</a>' .
                                ' | ' . $status .
                                ' | ' . '<a href="' . route("adv_detail", [$adv->id]) . '">' . $adv->name . '</a>' .
                                ' | ' . $entry->notes .
                                ' | ' . $entry->tracking_number;
                        }
                        return trans('module::message.ad_not_found');
                    } else if ($entry->item_type == 'package') {
                        if ($isActivePackages) {
                            $user_package_model = new UserModel();
                            $packageModel = new PackageModel();

                            if ($user_entry = $user_package_model->find($entry->item_id)
                                and $package = $packageModel->find($user_entry->package_id)) {
                                return $package->name;
                            }
                        }
                    } else if ($entry->item_type == 'ads-configuration') {
                        if ($configuration = $optionConfigurationRepository->find($entry->item_id)) {
                            return $configuration->getName();
                        }
                    } else if ($entry->item_type == 'doping') {
                        if ($isDopingsActive) {
                            $DopingModel = new DopingModel();
                            $doping = $DopingModel->newQuery()->find($entry->item_id);
                            return $doping->name;
                        }

                    } else if ($entry->item_type == 'balance') {
                        return trans('visiosoft.module.orders::field.balance.name');
                    } else if ($entry->item_type == 'Subscription') {
                        return "Plan Purchase";
                    } else if (in_array($entry->item_type, ['site', 'bundle'])) {
                        return $entry->notes;
                    }
                }
            ],
            'seller' => [
                'value' => function (EntryInterface $entry, AdvRepositoryInterface $repository, UserRepository $userRepository) {
                    if ($entry->item_type == 'adv' and $adv = $repository->getListItemAdv($entry->item_id)) {
                        if ($userRepository->find($adv->created_by_id)) {
                            return $adv->created_by_id . ' ' . $adv->lastname;
                        }
                        return trans('module::message.user_not_found');
                    }
                    return trans('module::message.system');
                }
            ],
            'price' => [
                'value' => 'entry.price.currency',
            ],
            'type' => [
                'value' => function (EntryInterface $entry) {
                    return $entry->getTypeTitle();
                }
            ],
            'piece',
            'commission' => [
                'value' => 'entry.commission ~"% "'],
            'total' => [
                'value' => 'entry.total.currency',
            ]
        ]);
    }
}
