<?php namespace Visiosoft\OrdersModule\CcLog;

use Visiosoft\OrdersModule\CcLog\Contract\CcLogInterface;
use Anomaly\Streams\Platform\Model\Orders\OrdersCcLogsEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CcLogModel extends OrdersCcLogsEntryModel implements CcLogInterface
{
    use HasFactory;

    /**
     * @return CcLogFactory
     */
    protected static function newFactory()
    {
        return CcLogFactory::new();
    }

    public function viewResponse()
    {
        $response = json_decode($this->response);
        if (json_last_error() === JSON_ERROR_NONE) {
            return json_encode($response, JSON_PRETTY_PRINT);
        }

        return $this->response;
    }
}
