<?php namespace Visiosoft\OrdersModule\Order\Table;

use Visiosoft\OrdersModule\Order\Contract\OrderInterface;
use Visiosoft\OrdersModule\Order\Table\Actions\Approve;
use Visiosoft\OrdersModule\Order\Table\Actions\Reject;

class OrderTableButtons
{
	public function handle(OrderTableBuilder $builder)
	{
		$builder->setButtons([
			'approve_order' => [
				'href' => function (OrderInterface $entry) {
					$status = ($entry->status != 'approved') ? 'approve' : 'reject';
					return "/admin/orders/" . $status . "/" . $entry->getId();
				},
				'class' => function (OrderInterface $entry) {
					return $entry->status == 'approved' ? 'btn btn-danger' : 'btn btn-success';
				},
				'text' => function (OrderInterface $entry) {
					return $entry->status == 'approved'
						? trans('visiosoft.module.orders::field.reject')
						: trans('visiosoft.module.orders::field.approve');
				},
			],
			'view' => [
				'href' => 'admin/orders/orderdetail?filter_order={entry.id}'
			]
		]);
	}
}
