<?php namespace Visiosoft\OrdersModule\Order;

use Anomaly\UsersModule\User\UserModel;
use Illuminate\Support\Facades\Auth;
use Visiosoft\BalancesModule\Balance\BalanceModel;
use Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController;
use Visiosoft\OrdersModule\Order\Contract\OrderInterface;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderEntryModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;

class OrderModel extends OrdersOrderEntryModel implements OrderInterface
{
    public function create_orders(array $attr)
    {
        return $this->create($attr)->getId();
    }

    public function orders_total($items)
    {
        $total = 0;
        foreach($items as $item){
            $total += $item->total;
        }
        return $total;
    }

    public function status($status,$id) {
        $orderDetail_model = new OrderdetailModel();
        $order_detail = $orderDetail_model->getDetail($id);
        foreach ($order_detail as $item)
        {
            if($status == 'approved')
            {
                $orderDetail_model->getOrder($item->id)->update(['status' => 'awaiting_tracking_number']);
                if($item->item_type == 'doping')
                {
                    $doping_controller = new DopingsController();
                    $doping_controller->approve($item->item_id);
                }
                else if($item->item_type == 'package')
                {
                    $package_model = new \Visiosoft\PackagesModule\User\UserModel();
                    $package_model->status($item->item_id,'approved');
                }
                else if($item->item_type == 'balance')
                {
                    $balance_model = new BalanceModel();
                    $balance_model->approve($item->item_id);
                }
            }
        }
        return $this->find($id)->update(['status' => $status]);
    }

    public function getOrder($id)
    {
        return $this->find($id);
    }

    public function getOrderUser($uid)
    {
        return UserModel::query()->find($uid);
    }

    public function getLastOrderByUser() {
        return OrderModel::query()
            ->where('user_id',Auth::id())
            ->orderByDesc('id')
            ->first();
    }

    public function listMyOrders() {
        return OrderModel::query()
            ->where('user_id',Auth::id())
            ->orderByDesc('id')->get();
    }

}
