<?php namespace Visiosoft\OrdersModule\CcLog\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class CcLogTableBuilder extends TableBuilder
{
    protected $filters = [
        'payment_type',
        'payment_order' => [
            'filter'  => 'input',
        ],
    ];

    protected $columns = [
        'entry.id',
        'payment_type',
        'success' => 'entry.success.value ? trans("module::field.yes") : trans("module::field.no")',
        'payment_order',
    ];

    protected $buttons = [
        'view' => [
            'data-toggle' => 'modal',
            'data-target' => '#modal',
            'href'        => 'admin/orders/cc_logs/view/{entry.id}',
        ],
    ];

    protected $actions = [
        'delete'
    ];

    protected $options = [
        'order_by' => [
            'id' => 'DESC'
        ]
    ];
}
