<?php namespace Visiosoft\OrdersModule\Http\Controller\Admin;

use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Order\Form\OrderFormBuilder;
use Visiosoft\OrdersModule\Order\Table\OrderTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\OrdersModule\Traits\ApproveTrait;
use Visiosoft\OrdersModule\Traits\RejectTrait;

class OrderController extends AdminController
{
	use ApproveTrait, RejectTrait;

    public function index(OrderTableBuilder $table)
    {
        return $table->render();
    }

    public function create(OrderFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(OrderFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function approve($id)
    {
        $this->approveOrder([$id]);
        return redirect('admin/orders');
    }

    public function reject($id)
    {
        $this->rejectOrder([$id]);
        return redirect('admin/orders');
    }

    public function delivered(OrderRepositoryInterface $orderRepository, $id)
    {
        $order = $orderRepository->find($id);

        if (!$order) {
            abort(404);
        }

        $order->delivered();

        $this->messages->success(trans('visiosoft.module.order::message.order_delivered'));

        return redirect('admin/orders');
    }
}
