<?php namespace Visiosoft\OrdersModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Support\Authorizer;
use Visiosoft\OrdersModule\PaymentReason\Contract\PaymentReasonRepositoryInterface;
use Visiosoft\OrdersModule\PaymentReason\Form\PaymentReasonFormBuilder;
use Visiosoft\OrdersModule\PaymentReason\Table\PaymentReasonTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class PaymentReasonController extends AdminController
{

    public function index(PaymentReasonTableBuilder $table)
    {
        return $table->render();
    }

    public function create(PaymentReasonFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(PaymentReasonFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function delete(PaymentReasonRepositoryInterface $paymentReasonRepository, Authorizer $authorizer, $id)
    {
        $authorizer->authorize('anomaly.module.orders::paymentreason.delete');

        $paymentReasonRepository->delete($paymentReasonRepository->find($id));

        return redirect()->back();
    }

}
