<?php namespace Visiosoft\OrdersModule\Traits;

use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Event\PaymentOrder;

trait ApproveTrait
{
	public function approveOrder(array $selected)
	{
		$orderRepoistory = app(OrderRepositoryInterface::class);
		foreach ($selected as $id) {
			if ($order = $orderRepoistory->find($id)
				and $order->status !== "approved") {

				$order->setStatus('approved', $id);

				event(new PaymentOrder($order->user, $order));
			}
		}

		if ($selected) {
			$this->messages->success(trans('module::message.orders_confirmed'));
		}
	}
}