<?php namespace Visiosoft\OrdersModule\RefundRequest\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class RefundRequestFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'refund_status' =>[
            'type' => 'anomaly.field_type.select',
            'config' => [
                'options' => [
                    'approved' => 'visiosoft.module.orders::field.approved',
                    'canceled' => 'visiosoft.module.orders::field.canceled',
                    'rejected' => 'visiosoft.module.orders::field.rejected',
                    'pending' => 'visiosoft.module.orders::field.pending'
                ],
            ],
        ],
        'refund_message'
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'update'
    ];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

}
