<?php namespace Visiosoft\OrdersModule\Orderpayment;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\OrdersModule\Orderpayment\Contract\OrderpaymentInterface;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderpaymentsEntryModel;

class OrderpaymentModel extends OrdersOrderpaymentsEntryModel implements OrderpaymentInterface
{
    public function addCancelPayment($orderDetail_id,$content)
    {
        $orderDetailModel = new OrderdetailModel();
        $order = $orderDetailModel->getOrder($orderDetail_id);
        $this->create(['user_id'=>$order['created_by_id'],'payment_reason'=>'cancel','order-detail_id'=>$order['id'],
            'price'=>$order['price'],'currency'=>$order['currency'],'content'=>$content,'status'=>'pending']);
    }

    public function approve($id,$type = null)
    {
        $payment = $this->find($id);
        if($type == 'seller')
        {
            $orderDetailModel = new OrderdetailModel();
            $orderDetailModel->setStatus($payment['order-detail_id'],'paid');
        }
        $payment->update(['status'=>'approved']);
    }

    public function getPayment($id)
    {
        return $this->find($id);
    }

    public function getPaymentUser($id,$type = null)
    {
        $payment = $this->getPayment($id);
        $id = $payment['order-detail_id'];
        $userModel = new UserModel();
        $orderDetailModel = new OrderdetailModel();
        $order = $orderDetailModel->getOrder($id);
        if($type == 'seller')
        {
            $advsModel = new AdvModel();
            $order = $advsModel->getAdv($order['item_id']);
        }
        return $userModel->find($order['created_by_id']);
    }

    public function addSalesPayment($orderDetail_id)
    {
        $orderDetailModel = new OrderdetailModel();
        $order = $orderDetailModel->getOrder($orderDetail_id);
        $advModel = new AdvModel();
        $adv = $advModel->getAdv($order->item_id);
        $this->create(['user_id'=>$adv['created_by_id'],'payment_reason'=>'sales','order-detail_id'=>$order['id'],
            'price'=>$order['total'],'currency'=>$order['currency'],'content'=>'Sales Process','status'=>'pending']);
    }
}
