<?php namespace Visiosoft\OrdersModule\Order\Table;

use Visiosoft\CartsModule\Cart\Event\CartsPay;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;

class OrderTableFilters
{
    private $orderRepository;

    public function __construct(OrderRepositoryInterface $orderRepository)
    {
        $this->orderRepository = $orderRepository;
    }

    public function handle(OrderTableBuilder $builder)
    {
        $type_filter_options = [
            'adv' => 'visiosoft.module.orders::field.adv.name',
            'ads-configuration' => 'visiosoft.module.orders::field.ads-configuration.name',
        ];

        //For Dopings
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.dopings')) ?
                ['doping' => 'visiosoft.module.orders::field.doping.name'] : []);

        //For Balances
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.balances')) ?
                ['balance' => 'visiosoft.module.orders::field.balance.name'] : []);

        //For Packages
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.packages')) ?
                ['package' => 'visiosoft.module.orders::field.package.name'] : []);

        //For Site
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.site')) ?
                ['site' => 'visiosoft.module.orders::field.site.name', 'bundle' => 'visiosoft.module.orders::field.bundle.name'] : []);

        //For Subscriptions
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.subscriptions')) ?
                ['Subscription' => 'visiosoft.module.orders::field.Subscription.name'] : []);

        //For Store
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.store')) ?
                ['store' => 'visiosoft.module.orders::field.store.name', 'store-doping' => 'visiosoft.module.orders::field.store-doping.name'] : []);

        $paymentTypes = [
            [
                'payment' => 'pay_at_door',
                'paymentName' => trans("visiosoft.module.carts::field.pay_at_door.name"),
            ],
            [
                'payment' => 'order',
                'paymentName' => trans("visiosoft.module.carts::message.bankorder"),
            ],
            [
                'payment' => 'pay_at_door',
                'paymentName' => trans("visiosoft.module.carts::field.pay_at_door.name"),
            ],
        ];
        $paymentTypes = array_merge($paymentTypes, event(new CartsPay([])));

        $paymentTypesOptions = array();
        foreach ($paymentTypes as $type) {
            $typeIsArray = is_array($type);
            $paymentType = $typeIsArray ? $type['payment'] : $type;
            $paymentTypesOptions[$paymentType] = $typeIsArray ? $type['paymentName'] : setting_value("visiosoft.module.payment_$type::payment_name",$type);
        }

        $filters = [
            'search' => [
                'filter' => 'search',
                'fields' => [
                    'bill_address_content',
                ],
            ],
            'order_at',
            'user',
            'status' => [
                'filter' => 'select',
                'placeholder' => trans('visiosoft.module.orders::field.status.name'),
                'options' => [
                    'approved' => trans('visiosoft.module.orders::field.approved'),
                    'rejected' => trans('visiosoft.module.orders::field.rejected'),
                    'pending' => trans('visiosoft.module.orders::field.pending'),
                ]
            ],
            'type' => [
                'filter' => 'select',
                'options' => $type_filter_options,
            ],
            'pay_type' => [
                'filter' => 'select',
                'options' => $paymentTypesOptions,
            ],
        ];

        $builder->setFilters($filters);
    }
}
