<?php namespace Visiosoft\OrdersModule\Order;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;

class OrderCriteria extends EntryCriteria
{

    private $orderRepository;

    public function __construct(
        Builder $query, StreamInterface $stream, $method,
        OrderRepositoryInterface $orderRepository
    )
    {
        parent::__construct($query, $stream, $method);
        $this->orderRepository = $orderRepository;
    }

    public function getUsersOrders($usersIDs, $pagination = 3)
    {
        return $this->orderRepository->getUsersOrders($usersIDs, $pagination, request()->starting_date, request()->end_date);
    }
}
