<?php namespace Visiosoft\OrdersModule\Order\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;

interface OrderRepositoryInterface extends EntryRepositoryInterface
{
    public function approveOrder($orderId);

    public function rejectOrder($orderId, $reason = null);

    public function createOrder($user_id, $total, $subtotal, $currency, $pay_type, $bill_address_id = null, $delivery_address_id = null);

    public function getUsersOrders($usersIDs, $paginate = 3, $startDate = null, $endDate = null);

    public function getUsersOrdersTotal($usersIDs, $startDate = null, $endDate = null);

    public function getUsedPaymentTypes();

    public function getOrdersReportByCity();

    public function getOrdersReportByPaymentType();

    public function getOrdersReportByMember();
}
