<?php namespace Visiosoft\OrdersModule\Order\Command;

use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;

class GetUsersOrdersTotal
{
    protected $usersIDs;
    protected $startDate;
    protected $endDate;

    public function __construct($usersIDs, $startDate = null, $endDate = null)
    {
        $this->usersIDs = $usersIDs;
        $this->startDate = $startDate;
        $this->endDate = $endDate;
    }

    public function handle(OrderRepositoryInterface $orderRepository)
    {
        return $orderRepository->getUsersOrdersTotal($this->usersIDs, $this->startDate, $this->endDate);
    }
}
