<?php namespace Visiosoft\OrdersModule\Http\Controller\Admin;

use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Form\OrderdetailFormBuilder;
use Visiosoft\OrdersModule\Orderdetail\Table\OrderdetailTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class OrderdetailController extends AdminController
{
    protected $orderdetailRepository;

    public function __construct(OrderdetailRepositoryInterface $orderdetailRepository)
    {
        parent::__construct();
        $this->orderdetailRepository = $orderdetailRepository;
    }

    public function index(OrderdetailTableBuilder $table)
    {
        return $table->render();
    }

    public function create(OrderdetailFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(OrderdetailFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function print($id)
    {
        $orderDetail = $this->orderdetailRepository->find($id);

        if (!$orderDetail) {
            abort(404);
        }

        return view('visiosoft.module.orders::admin/order-detail/print')->with('orderDetail', $orderDetail);
    }

    public function getDescriptionModal($orderDetailID)
    {
        return view('visiosoft.module.orders::admin/order-detail/description')->with('id', $orderDetailID);
    }

    public function addOrderDescription($orderDetailID)
    {
        try {
            $orderDetail = $this->orderdetailRepository->find($orderDetailID);

            if (!$orderDetail) {
                throw new \Exception(trans('visiosoft.module.orders::message.order_detail_not_found'));
            }

            if ($description = request('description')) {
                $orderDetail->addDescription($description);
            }

            $this->messages->success(trans('visiosoft.module.orders::message.description_added'));

            return back();
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
            return back();
        }
    }
}
