<?php namespace Visiosoft\OrdersModule\Http\Controller\Admin;

use Visiosoft\OrdersModule\Events\OrderDelivered;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Order\Form\OrderFormBuilder;
use Visiosoft\OrdersModule\Order\Table\OrderTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\OrdersModule\Orderpayment\OrderpaymentModel;
use Visiosoft\OrdersModule\Traits\ApproveTrait;
use Visiosoft\OrdersModule\Traits\RejectTrait;

class OrderController extends AdminController
{
	use ApproveTrait, RejectTrait;

    public function index(OrderTableBuilder $table)
    {
        return $table->render();
    }

    public function create(OrderFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(OrderFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function approve($id)
    {
        $this->approveOrder([$id]);
        return redirect('admin/orders');
    }

    public function reject($id)
    {
        $this->rejectOrder([$id]);
        return redirect('admin/orders');
    }

    public function delivered(OrderpaymentModel $orderpaymentModel, OrderRepositoryInterface $orderRepository, $id)
    {
        try {
            $order = $orderRepository->find($id);

            if (!$order) {
                throw new \Exception(trans('visiosoft.module.orders::message.order_not_found'));
            }

            foreach ($order->details as $orderItem) {
                event(new OrderDelivered($orderItem->id));

                $orderItem->delivered();
                $orderpaymentModel->addSalesPayment($orderItem->id);
            }

            $this->messages->success(trans('visiosoft.module.orders::message.order_delivered'));
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }


        return redirect('admin/orders');
    }

    public function print(OrderRepositoryInterface $orderRepository, $id)
    {
        $order = $orderRepository->find($id);

        if (!$order) {
            abort(404);
        }

        return view('visiosoft.module.orders::admin/print')->with('order', $order);
    }
}
