let currOrderPage = {}

$('.orders-table').on('click', '.load-more', function () {
    $(this).find('div').show()

    const userID = $(this).data('users_ids')
    const currTypePage = currOrderPage[userID] || 1

    crudAjax({ page: currTypePage + 1, users_ids: userID }, orderLink)
        .then(response => {
            if (response.success) {
                const data = response.data.data
                const orderTable = $(this).closest('tbody')

                for (let i = 0; i < data.length; i++) {
                    orderTable.append(`
                    <tr>
                        <td>${ data[i].ordered_by_name }</td>
                        <td>${ data[i].pay_type_name }</td>
                        <td>${ data[i].subtotal_formatted }</td>
                        <td>${ data[i].post_commission_formatted }</td>
                    </tr>
                `)
                }

                $(this).closest('tr').remove()

                if (response.data.last_page !== response.data.current_page) {
                    orderTable.append(`
                    <tr class="load-more-wrapper">
                        <td colspan="4">
                            <button class="border-0 w-100 h-100 p-0 load-more d-flex align-items-center justify-content-center"
                                    data-user_id="${ userID }">
                                <div class="spinner-border spinner-border-sm" role="status" style="display: none"></div>
                                ${ loadMoreOrderTrans }
                            </button>
                        </td>
                    </tr>
                `)
                }

                currOrderPage[userID] = response.data.current_page
            } else {
                alert(response.message)
            }
        })
        .fail(function(xhr, status, error) {
            alert(xhr.responseText)
        })
})
