<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;

class VisiosoftModuleOrdersCreateRefundRequestStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'refund_request',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'refund_request_message' => 'anomaly.field_type.text',
        'refund_status' => 'anomaly.field_type.text',
        'refund_message' => 'anomaly.field_type.text',
        'order_detail' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => OrderdetailModel::class
            ]
        ],
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'order_detail' => [
            'required' => true,
        ],
        'refund_request_message',
        'refund_status',
        'refund_message'
    ];

}
