<?php namespace Visiosoft\OrdersModule\Orderdetail\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\UsersModule\User\UserRepository;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\OptionConfiguration\Contract\OptionConfigurationRepositoryInterface;
use Visiosoft\AdvsModule\Support\Command\Currency;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailRepository;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\User\UserModel;
use Visiosoft\DopingsModule\Doping\DopingModel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class OrderdetailTableColumns
{
    public function handle(OrderdetailTableBuilder $builder)
    {
        $builder->setColumns([
            'item_id' => [
                'value' => function (EntryInterface $entry,
                                     AdvRepositoryInterface $repository,
                                     OrderdetailRepository $orderdetailRepository,
                                     OptionConfigurationRepositoryInterface $optionConfigurationRepository) {
                    $isActivePackages = is_module_installed('visiosoft.module.packages');
                    $isDopingsActive = is_module_installed('visiosoft.module.dopings');
                    if ($entry->item_type == 'adv') {
                        $adv = $repository->getListItemAdv($entry->item_id);
                        $status = $orderdetailRepository->getStatus($entry->id);
                        if ($adv) {
                            return '<a href="' . route("adv_detail", [$adv->id]) . '">' . $adv->id . '</a>' .
                                ' | ' . $status .
                                ' | ' . '<a href="' . route("adv_detail", [$adv->id]) . '">' . $adv->name . '</a>' .
                                ' | ' . $entry->notes .
                                ' | ' . $entry->tracking_number;
                        }
                        return trans('module::message.ad_not_found');
                    } else if ($entry->item_type == 'package') {
                        if ($isActivePackages) {
                            $user_package_model = new UserModel();
                            $packageModel = new PackageModel();

                            if ($user_entry = $user_package_model->find($entry->item_id)
                                and $package = $packageModel->find($user_entry->package_id)) {
                                return $package->name;
                            }
                        }
                    } else if ($entry->item_type == 'ads-configuration') {
                        if ($configuration = $optionConfigurationRepository->find($entry->item_id)) {
                            return $configuration->getName();
                        }
                    } else if ($entry->item_type == 'doping') {
                        if ($isDopingsActive) {
                            $DopingModel = new DopingModel();
                            $doping = $DopingModel->newQuery()->withTrashed()->find($entry->item_id);
                            return $doping->name ?? $entry->notes;
                        }

                    } else if ($entry->item_type == 'balance') {
                        return trans('visiosoft.module.orders::field.balance.name');
                    } else if ($entry->item_type == 'Subscription') {
                        return "Plan Purchase";
                    } else if (in_array($entry->item_type, ['site', 'bundle'])) {
                        return $entry->notes;
                    }
                }
            ],
            'seller' => [
                'value' => function (EntryInterface $entry, AdvRepositoryInterface $repository, UserRepository $userRepository) {
                    if ($entry->item_type === 'adv' && $adv = $repository->getListItemAdv($entry->item_id)) {
                    	if ($seller = $entry->seller) {
		                    if (is_module_installed('visiosoft.module.store') && $store = app(StoreRepositoryInterface::class)->findByUser($seller->id)){
			                    return $store->id . ' ' . $store->name . ' <br> ' . $seller->first_name . ' ' . $seller->last_name;
		                    }
		                    return $seller->id . ' ' . $seller->last_name;
	                    } elseif ($userRepository->find($adv->created_by_id)) {
                            return $adv->created_by_id . ' ' . $adv->lastname;
                        }
                        return trans('module::message.user_not_found');
                    }
                    return trans('module::message.system');
                }
            ],
            'type' => [
                'value' => function (EntryInterface $entry) {
                    return $entry->getTypeTitle();
                }
            ],
            'piece',
            'price' => [
                'value' => 'entry.price.currency',
            ],
            'payable_to_seller' => [
                'value' => function (EntryInterface $entry, Currency $currency) {
                    return $currency->format(($entry->price - ($entry->price * $entry->commission / 100)), $entry->currency);
                }
            ],
            'commission' => [
                'value' => function (EntryInterface $entry, Currency $currency) {
                    return $currency->format(($entry->price * $entry->commission / 100), $entry->currency) . " | %" . $entry->commission;
                }
            ],
            'total' => [
                'value' => 'entry.total.currency',
            ]
        ]);
    }
}
