<?php namespace Visiosoft\OrdersModule\Orderdetail;

use Anomaly\Streams\Platform\Entry\EntryPresenter;
use Rinvex\Subscriptions\Models\Plan;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\LocationModule\District\DistrictModel;
use Visiosoft\LocationModule\Neighborhood\NeighborhoodModel;
use Visiosoft\LocationModule\Village\VillageModel;
use Visiosoft\DopingsModule\Doping\DopingModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\User\UserModel;
use Visiosoft\PackagesModule\Userentry\UserentryModel;
use Visiosoft\ProfileModule\Adress\AdressModel;

class OrderdetailPresenter extends EntryPresenter
{
    public function get_order($id)
    {
        $order_Model = new OrderModel();
        return $order_Model->getOrder($id);
    }

    public function get_bill_address($item)
    {
        $id = $this->getObject()->order_id;
        $order_Detail = $this->get_order($id);
        $address_Model = new AdressModel();
        $bill_address = $address_Model->getAdressFirst($order_Detail->bill_address_id);
        return $bill_address ? $bill_address->toArray()[$item] : null;
    }

    public function get_delivery_address($item)
    {
        $id = $this->getObject()->order_id;
        $order_Detail = $this->get_order($id);
        $address_Model = new AdressModel();
        $delivery_address = $address_Model->getAdressFirst($order_Detail->delivery_address_id);
        return $delivery_address ? $delivery_address->toArray()[$item] : null;
    }

    public function getTotal($type)
    {
        $order_Model = new OrderModel();
        $order = $order_Model->getOrder($this->getObject()->order_id);
        return $order->$type;
    }

    public function getOrderType()
    {
        $order_Model = new OrderModel();
        $order = $order_Model->getOrder($this->getObject()->order_id);
        return $order->pay_type;

    }

    public function getStatus()
    {
        $order_Model = new OrderModel();
        $order = $order_Model->getOrder($this->getObject()->order_id);
        return $order->status;
    }

    public function getSubject()
    {
        $id = $this->getObject()->item_id;
        if ($this->getObject()->item_type == 'adv') {
            $advModel = new AdvModel();
            return $advModel->getAdv($id)->name;
        } elseif ($this->getObject()->item_type == 'package') {
            $packageUserModel = new UserModel();
            $PackageModel = new PackageModel();
            $entry = $packageUserModel->find($id)->first();
            $package = $PackageModel->getPackage($entry->package_id);
            return $package->name;
        } else if ($this->getObject()->item_type == 'doping') {
            $DopingModel = new DopingModel();
            $doping = $DopingModel->isDoping($id);
            return $doping->name;
        } else if ($this->getObject()->item_type == 'balance') {
            return trans('visiosoft.module.orders::field.balance.name');
        } elseif ($this->getObject()->item_type == 'Subscription') {
            $plan = Plan::query()->find($id);
            return $plan->name . " " . trans('visiosoft.module.subscriptions::field.plan.basic');
        }
    }

    public function getPhoto()
    {
        $id = $this->getObject()->item_id;
        if ($this->getObject()->item_type == 'adv') {
            $advModel = new AdvModel();
            $adv = $advModel->getAdv($id);
            if ($adv != null and $adv->cover_photo != null) {
                return url($adv->cover_photo);
            }
        } else {
            return null;
        }
    }

    public function statusClass($static)
    {
        $status = $this->getObject()->status;
        if ($status == $static) {
            return 'warning-color';
        }
    }

    public function getLocationAddress($type)
    {
        $id = $this->getObject()->order_id;
        $order_Detail = $this->get_order($id);
        $address_Model = new AdressModel();
        if ($type == 'bill') {
            $address = $address_Model->getAdressFirst($order_Detail->bill_address_id);
            $address = $address ? $address->toArray() : null;
        } else {
            $address = $address_Model->getAdressFirst($order_Detail->delivery_address_id);
            $address = $address ? $address->toArray() : null;
        }

        if (!$address) {
            return null;
        }

        $country_model = new CountryModel();
        $city_model = new CityModel();
        $district_model = new DistrictModel();
        $neighborhood_model = new NeighborhoodModel();
        $village_model = new VillageModel();

        $return = $district_model->find($address['district'])->name .
            " / " . $city_model->find($address['city'])->name .
            " / " . $country_model->find($address['country_id'])->name;

        if (isset($address['neighborhood']) && $address['neighborhood'] != "") {
            $return = $neighborhood_model->find($address['neighborhood'])->name .
                " / " . $return;
        }

        if (isset($address['village']) && $address['village'] != "") {
            $return = $village_model->find($address['village'])->name .
                " / " . $return;
        }

        return $return;
    }

}
