<?php namespace Visiosoft\OrdersModule\Http\Controller\Admin;

use Anomaly\AddonsModule\Addon\Table\Entries\AllEntries;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Model\Advs\AdvsDistrictsEntryModel;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Category\CategoryModel;
use Visiosoft\BalancesModule\Balance\BalanceModel;
use Visiosoft\CartsModule\Cart\CartModel;
use Visiosoft\DopingsModule\Doping\DopingModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Orderdetail\Form\OrderdetailFormBuilder;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailRepository;
use Visiosoft\OrdersModule\Orderdetail\Table\OrderdetailTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\ProfileModule\Adress\AdressModel;

class OrderdetailController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param OrderdetailTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(OrderdetailTableBuilder $table)
    {
        $isActive = new AdvModel();
        $table->setColumns(['item_id' => [
            'value' => function (EntryInterface $entry, AdvRepositoryInterface $repository, OrderdetailRepository $orderdetailRepository) {
                $isActive = new AdvModel();
                $isActivePackages = $isActive->is_enabled('packages');
                $isDopingsActive = $isActive->is_enabled('dopings');
                if ($entry->item_type == 'adv') {
                    $adv = $repository->getListItemAdv($entry->item_id);
                    $status = $orderdetailRepository->getStatus($entry->id);
                    return $status . ' | ' . $adv->name . ' | ' . $entry->notes . ' | ' . $entry->tracking_number;
                } else if ($entry->item_type == 'package') {
                    if ($isActivePackages) {
                        $packageModel = new PackageModel();
                        $package = $packageModel->getPackage($entry->item_id);
                        return $package->name;
                    }
                } else if ($entry->item_type == 'doping') {
                    if ($isDopingsActive) {
                        $DopingModel = new DopingModel();
                        $doping = $DopingModel->isDoping($entry->item_id);
                        return $doping->name;
                    }

                } else if ($entry->item_type == 'balance') {
                    return trans('visiosoft.module.orders::field.balance.name');
                } else if ($entry->item_type == 'Subscription') {
                    return "Plan Purchase";
                }
            }
        ],
            'seller' => [
                'value' => function (EntryInterface $entry, AdvRepositoryInterface $repository) {
                    if ($entry->item_type == 'adv') {

                        $adv = $repository->getListItemAdv($entry->item_id);
                        return $adv->firstname . ' ' . $adv->lastname;
                    } else {
                        return 'System';
                    }
                }
            ]
            , 'price' => [
                'value' => 'entry.price.currency',
            ], 'piece', 'commission' => ['value' => 'entry.commission ~"% "'], 'total' => [
                'value' => 'entry.total.currency',
            ]]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param OrderdetailFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(OrderdetailFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param OrderdetailFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(OrderdetailFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
