<?php namespace Visiosoft\OrdersModule\Order\Table\Actions;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;

class Reject extends ActionHandler
{
    public function handle(OrderRepositoryInterface $orderRepoistory, array $selected)
    {
        foreach ($selected as $id) {
            if ($order = $orderRepoistory->find($id)
                and $order->status !== "reject") {

                $order->setStatus('reject', $id);
            }
        }

        if ($selected) {
            $this->messages->success(trans('module::message.orders_rejected'));
        }
    }
}