<?php namespace Visiosoft\OrdersModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Illuminate\Events\Dispatcher;
use Visiosoft\OrdersModule\Order\Form\OrderFormBuilder;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Order\Table\OrderTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\OrdersModule\Orderdetail\Event\PaymentOrder;
use Visiosoft\OrdersModule\Traits\ApproveTrait;
use Visiosoft\OrdersModule\Traits\RejectTrait;

class OrderController extends AdminController
{
	use ApproveTrait, RejectTrait;
    /**
     * Display an index of existing entries.
     *
     * @param OrderTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(OrderTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param OrderFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(OrderFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param OrderFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(OrderFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function approve($id)
    {
        $this->approveOrder([$id]);
        return redirect('admin/orders');
    }

    public function reject($id)
    {
        $this->rejectOrder([$id]);
        return redirect('admin/orders');
    }
}
