<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleOrdersCreateCcLogsStream extends Migration
{
    protected $delete = true;

    protected $stream = [
        'slug' => 'cc_logs',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        "message" => "anomaly.field_type.text",
        "response" => [
            "type"   => "anomaly.field_type.editor",
            "config" => [
                "mode" => "json",
            ]
        ],
        "success" => "anomaly.field_type.boolean",
        "payment_order" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\OrdersModule\Order\OrderModel::class,
                "mode" => "lookup",
            ]
        ],
    ];

    protected $assignments = [
        'payment_type',
        'message',
        'response',
        'success',
        'payment_order',
    ];
}
