<?php namespace Visiosoft\OrdersModule\Orderdetail;

use Anomaly\Streams\Platform\Model\Users\UsersUsersEntryModel;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailInterface;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderdetailEntryModel;

class OrderdetailModel extends OrdersOrderdetailEntryModel implements OrderdetailInterface
{
    public function create_datail(array $attr)
    {
        return $this->create($attr)->getId();
    }

    public function getDetail($id)
    {
        return $this->where('order_id', $id)->get();
    }

    public function getOrder($id)
    {
        return $this->find($id);
    }

    public function listMySales()
    {
        $advModel = new AdvModel();

        $my_ads = $advModel->getAdv(null, false)
            ->where('advs_advs.created_by_id', Auth::id())
            ->get()
            ->pluck('id')
            ->all();

        return $this->whereIn('item_id', $my_ads)->orderByDesc('id')
            ->get();
    }

    public function setStatus($id, $type)
    {
        $this->find($id)->update(['status' => $type]);
    }

}
