<?php namespace Visiosoft\OrdersModule\Order\Table\Actions;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Event\PaymentOrder;

class Approve extends ActionHandler
{
    public function handle(OrderRepositoryInterface $orderRepoistory, array $selected)
    {
        foreach ($selected as $id) {
            if ($order = $orderRepoistory->find($id)
                and $order->status !== "approved") {

                $order->setStatus('approved', $id);

                event(new PaymentOrder($order->user, $order));
            }
        }

        if ($selected) {
            $this->messages->success(trans('module::message.orders_confirmed'));
        }
    }
}