<?php namespace Visiosoft\OrdersModule\Order\Command;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\OrdersModule\PaymentName\Contract\PaymentNameRepositoryInterface;

class GetPayTypeName
{
    use DispatchesJobs;

    protected $payType;

    public function __construct($payType)
    {
        $this->payType = $payType;
    }

    public function handle(PaymentNameRepositoryInterface $paymentNameRepository)
    {
        if ($this->payType === 'order' || $this->payType === 'pay_at_door') {
            $paymentName = $paymentNameRepository->findBy('payment_type', $this->payType);
            return $paymentName ? $paymentName->payment_name : $this->payType;
        } elseif ($this->payType === 'stripe') {
            $paymentName = $this->dispatch(new \Visiosoft\PaymentStripeModule\PaymentName\Command\GetPayTypeName());
            return $paymentName ?: $this->payType;
        }

        return $this->payType;
    }
}
