<?php namespace Visiosoft\OrdersModule\Order\Command;

use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;

class GetOrder
{

    /**
     * @var $id
     */
    protected $id;

    /**
     * GetProduct constructor.
     * @param $id
     */
    public function __construct($id)
    {
        $this->id = $id;
    }

    /**
     * @param OrderRepositoryInterface $groups
     * @return \Anomaly\Streams\Platform\Model\EloquentModel|null
     */
    public function handle(OrderRepositoryInterface $groups)
    {
        if ($this->id) {
            return $groups->find($this->id);
        }
        return null;
    }
}
