<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\ProfileModule\Adress\AdressModel;

class VisiosoftModuleOrdersCreateOrdersFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ]
        ],
        'status' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'options'       => [
                    'approved' => 'Approved',
                    'pending' => 'Pending',
                    ],
                'separator'     => ':',
            ],
        ],
        'pay_type' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'options'       => ['order' => 'Orders',
                                    'paypal' => 'Paypal',
                                    'stripe' => 'Stripe',
                                    'iyzico' => 'Iyzico',
                                    'balance' => 'Balances'],
            'separator'     => ':',
                    ],
        ],
        'subtotal' => 'visiosoft.field_type.decimal',
        'shipping' => 'visiosoft.field_type.decimal',
        'total' => 'visiosoft.field_type.decimal',
        'currency' => [
            'type'     => 'anomaly.field_type.select',
            'config'   => [
                'handler' => 'currencies',
            ],
        ],
        'item_id' => 'anomaly.field_type.integer',
        'item_type' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'options'       => [
                    'adv' => 'Adv',
                    'doping' => 'Doping',
                    'package' => 'Package',
                    'balance' => 'Balance'
                ],
                'separator'     => ':',
            ],
        ],
        'piece' => 'anomaly.field_type.integer',
        'price' => 'visiosoft.field_type.decimal',
        'commission' => 'anomaly.field_type.integer',
        'order' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => OrderModel::class
            ]
        ],
        'order_at' => 'anomaly.field_type.datetime',
        'bill_address' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => AdressModel::class
            ]
        ],
        'delivery_address' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => AdressModel::class
            ]
        ],
        'tracking_number' => 'anomaly.field_type.text',
        'transport_days' => 'anomaly.field_type.integer',
        'report_content' => 'anomaly.field_type.text',
        'payment_reason' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'options'       => ['cancel' => 'Cancel',
                    'sales' => 'Sales'],
                'separator'     => ':',
            ],
        ],
        'content' => 'anomaly.field_type.text',
        'order-detail' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => OrderdetailModel::class
            ]
        ],
    ];

}
