<?php namespace Visiosoft\OrdersModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\OrdersModule\Order\Command\GetOrder;
use Visiosoft\OrdersModule\Order\Command\GetPayTypeName;
use Visiosoft\OrdersModule\Order\Command\GetUsersOrdersTotal;

class OrdersModulePlugin extends Plugin
{
    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getOrder',
                function ($id) {

                    if (!$ad = $this->dispatch(new GetOrder($id))) {
                        return null;
                    }
                    return $ad;
                }
            ),
            new \Twig_SimpleFunction(
                'payTypeName',
                function ($payType) {
                    return $this->dispatch(new GetPayTypeName($payType));
                }
            ),
            new \Twig_SimpleFunction(
                'getUsersOrdersTotal',
                function ($usersIDs) {
                    return $this->dispatch(new GetUsersOrdersTotal($usersIDs));
                }
            ),
        ];
    }
}
