<?php namespace Visiosoft\OrdersModule\Order;

use Visiosoft\AdvsModule\Support\Command\Currency;
use Visiosoft\OrdersModule\Order\Command\GetPayTypeName;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;

class OrderRepository extends EntryRepository implements OrderRepositoryInterface
{
    protected $model;
    protected $orderdetail;
    protected $currency;

    public function __construct(OrderModel $model, OrderdetailRepositoryInterface $orderdetail, Currency $currency)
    {
        $this->model = $model;
        $this->orderdetail = $orderdetail;
        $this->currency = $currency;
    }

    public function approveOrder($orderId)
    {
        $this->model->setStatus('approved', $orderId);
    }

    public function rejectOrder($orderId)
    {
        $this->find($orderId)->update(['status' => 'rejected']);
    }

    public function createOrder($user_id, $total, $subtotal, $currency, $pay_type, $bill_address_id = null, $delivery_address_id = null)
    {
        return $this->create([
            'pay_type' => $pay_type,
            'subtotal' => $subtotal,
            'user_id' => $user_id,
            'total' => $total,
            'currency' => $currency,
            'order_at' => now(),
            'status' => 'pending',
            'bill_address_id' => $bill_address_id,
            'delivery_address_id' => $delivery_address_id,
        ]);
    }

    public function getUsersOrders($usersIDs, $paginate = 3)
    {
        $orders = $this->newQuery()
            ->whereIn('user_id', $usersIDs)
            ->paginate($paginate);

        foreach ($orders as $order) {
            $order->setAttribute('pay_type_name', dispatch_now(new GetPayTypeName($order->pay_type)));
            $order->setAttribute('ordered_by_name', $order->user->name());
            $order->setAttribute('total_formatted', $this->currency->format($order->total, $order->currency));
            $order->setAttribute(
                'post_commission_formatted',
                $this->currency->format((1 - auth()->user()->commission / 100) * $order->total, $order->currency)
            );
        }

        return $orders;
    }

    public function getUsersOrdersTotal($usersIDs)
    {
        if (count($usersIDs)) {
            $ordersTotal = $this->newQuery()
                ->whereIn('user_id', $usersIDs)
                ->sum('total');

            return $ordersTotal;
        }

        return null;
    }
}
