<?php

use Visiosoft\OrdersModule\Handler\PayType;

return [
    'default_payment_type' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'default_value' => null,
            'handler' => PayType::class
        ],
    ],
    'commission' => [
        'type' => 'anomaly.field_type.decimal',
        'config' => [
            'default_value' => 0.00,
            'min' => 0,
            'max' => 100,
        ],
    ],
    'tax' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 0,
            'max' => 100,
        ],
    ],
    'shipping' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 10,
        ],
    ],
    'refund_policy' => [
        'type' => 'anomaly.field_type.wysiwyg',
        'config' => [
            'default_value' => 'Example',
        ],
    ],

    'show_tax' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => true,
        ],
    ],

    'show_commission' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => true,
        ],
    ],

    'show_shipping' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => true,
        ],
    ],
];
