<?php namespace Visiosoft\OrdersModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Order\Table\OrderTableBuilder;
use Visiosoft\OrdersModule\Orderdetail\Event\AgainPurchaseOrder;
use Visiosoft\OrdersModule\Orderdetail\Event\AgainSaleOrder;
use Visiosoft\OrdersModule\Orderdetail\Event\ReportOrder;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailRepository;
use Visiosoft\OrdersModule\Orderpayment\OrderpaymentModel;

class OrderController extends PublicController
{
    /**
     * @var AdvModel
     */
    private $adv_model;
    /**
     * @var OrderModel
     */
    private $model;
    /**
     * @var OrderdetailModel
     */
    private $order_detail_model;
    /**
     * @var OrderdetailRepository
     */
    private $order_detail_repository;
    /**
     * @var OrderpaymentModel
     */
    private $order_payment_model;

    /**
     * OrderController constructor.
     * @param AdvModel $advModel
     * @param OrderModel $orderModel
     * @param OrderdetailModel $orderdetailModel
     * @param OrderdetailRepository $orderdetailRepository
     * @param OrderpaymentModel $orderpaymentModel
     */
    public function __construct(
        AdvModel $advModel,
        OrderModel $orderModel,
        OrderdetailModel $orderdetailModel,
        OrderdetailRepository $orderdetailRepository,
        OrderpaymentModel $orderpaymentModel)
    {
        $this->adv_model = $advModel;
        $this->model = $orderModel;
        $this->order_detail_model = $orderdetailModel;
        $this->order_detail_repository = $orderdetailRepository;
        $this->order_payment_model = $orderpaymentModel;
        parent::__construct();

        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }

    }

    /**
     * @param OrderTableBuilder $table
     * @return \Illuminate\Contracts\View\View|mixed
     */
    public function sale(OrderTableBuilder $table)
    {
        $mySales = $this->order_detail_model->listMySales();
        foreach ($mySales as $index => $mySale) {
            if ($mySale->item_type == 'adv') {
                $mySales[$index]->detail_url = $this->adv_model->getAdvDetailLinkByAdId($mySale->item_id);
            }
            $mySales[$index]->detail_url = "#";
        }
        return $this->view->make('visiosoft.module.orders::sale/index', compact('mySales'));
    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\View|mixed
     */
    public function saleDetail($id)
    {
        $details = $this->order_detail_model->getOrder($id);
        if ($details->item_type == "adv") {
            $details->detail_url = $this->adv_model->getAdvDetailLinkByAdId($details->item_id);
        } else {
            $details->detail_url = "#";
        }
        return $this->view->make('visiosoft.module.orders::sale/detail', compact('details'));
    }

    /**
     * @return \Illuminate\Contracts\View\View|mixed
     */
    public function purchase()
    {
        $myPurchase = $this->model->listMyOrders();
        return $this->view->make('visiosoft.module.orders::purchase/index', compact('myPurchase'));
    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\View|mixed
     */
    public function purchaseDetail($id)
    {
        $details = $this->order_detail_model->getDetail($id);
        foreach ($details as $index => $detail) {
            if ($detail->item_type == "adv") {
                $details[$index]->detail_url = $this->adv_model->getAdvDetailLinkByAdId($detail->item_id);
            } else {
                $details[$index]->detail_url = "#";
            }
        }
        return $this->view->make('visiosoft.module.orders::purchase/detail', compact('details'));
    }

    /**
     * @return \Illuminate\Http\RedirectResponse
     */
    public function addTrackingNumber()
    {
        $this->order_detail_repository
            ->addTransportnumber($this->request->id, $this->request->transportNumber, $this->request->transportDays);
        return back()->with('success', ['Success']);
    }

    /**
     * @param $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function orderDelivered($id)
    {
        $this->order_detail_model->status($id, 'paid_buyer');
        $this->order_payment_model->addSalesPayment($id);
        return back()->with('success', ['Success']);
    }

    /**
     * @param $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function orderNotDelivered($id)
    {
        $this->order_detail_model->status($id, 'error_buyer');
        return back()->with('success', ['Success']);
    }

    /**
     * @return \Illuminate\Http\RedirectResponse
     */
    public function reportSales()
    {
        if ($this->request->status == 'sendAgain') {
            $seller = Auth::user();
            $buyer = $this->order_detail_repository->getOrderUser($this->request->id);
            $this->order_detail_repository
                ->report($this->request->id, $this->request->reportContent, 'awaiting_tracking_number');

            $this->events->dispatch(new AgainPurchaseOrder($this->request->reportContent, $buyer));
            $this->events->dispatch(new AgainSaleOrder($this->request->reportContent, $seller));

//                $buyer->notify(new AgainPuchaseOrder($request->reportContent, $buyer['display_name']));/*notify*/
//                $seller->notify(new AgainSaleOrder($request->reportContent, $seller['display_name']));/*notify*/

        } else {
            $this->order_detail_repository->report($this->request->id, $this->request->reportContent);
            $user = $this->order_detail_repository->getOrderUser($this->request->id);
            $this->order_payment_model->addCancelPayment($this->request->id, $this->request->reportContent);

            $this->events->dispatch(new ReportOrder($this->request->reportContent, $user));
//                $user->notify(new ReportOrder($request->reportContent, $user['display_name']));/*notify*/

        }
        return back()->with('success', ['Success']);
    }
}