<?php namespace Visiosoft\OrdersModule\Orderdetail;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\OrdersModule\Order\Events\AddedTrackingNumber;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class OrderdetailRepository extends EntryRepository implements OrderdetailRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var OrderdetailModel
     */
    protected $model;

    /**
     * Create a new OrderdetailRepository instance.
     *
     * @param OrderdetailModel $model
     */
    public function __construct(OrderdetailModel $model)
    {
        $this->model = $model;
    }

    public function getStatus($id)
    {
        $status = $this->model->getOrder($id)->status;
        return trans('visiosoft.module.orders::field.' . $status . '.name');
    }

    public function getOrderUser($id)
    {
        $orderDetail = $this->find($id);
        $userModel = new UserModel();
        $user = $userModel->find($orderDetail['created_by_id']);
        return $user;

    }

    public function addTransportnumber($id, $number, $day, $detail_url)
    {
        if ($order_detail = $this->find($id)) {
            $order_detail->update(
                [
                    'tracking_number' => $number,
                    'status' => 'awaiting_payment_approval',
                    'transport_days' => $day,
                    'transport_detail_url' => $detail_url
                ]);

            event(new AddedTrackingNumber($order_detail));
        }
    }

    public function report($id, $message, $status = 'cancelled')
    {
        $this->find($id)->update(['status' => $status, 'report_content' => $message]);
        if ($status == "awaiting_tracking_number") {
            $this->find($id)->update(['tracking_number' => null]);
        }
    }

    public function createDetail($item_id, $item_type, $price, $currency, $total, $order_id, $piece = 1, $status = null)
    {
        return $this->create([
            'item_id' => $item_id,
            'item_type' => $item_type,
            'price' => $price,
            'currency' => $currency,
            'piece' => $piece,
            'status' => $status,
            'total' => $total,
            'order_id' => $order_id
        ]);
    }
}
