<?php namespace Visiosoft\OrdersModule\Order;

use Visiosoft\AdvsModule\Support\Command\Currency;
use Visiosoft\OrdersModule\Order\Command\GetPayTypeName;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;

class OrderRepository extends EntryRepository implements OrderRepositoryInterface
{
    protected $model;
    protected $orderdetail;
    protected $currency;

    public function __construct(OrderModel $model, OrderdetailRepositoryInterface $orderdetail, Currency $currency)
    {
        $this->model = $model;
        $this->orderdetail = $orderdetail;
        $this->currency = $currency;
    }

    public function approveOrder($orderId)
    {
        $this->model->setStatus('approved', $orderId);
    }

    public function rejectOrder($orderId)
    {
        $this->find($orderId)->update(['status' => 'rejected']);
    }

    public function createOrder($user_id, $total, $subtotal, $currency, $pay_type, $bill_address_id = null, $delivery_address_id = null)
    {
        return $this->create([
            'pay_type' => $pay_type,
            'subtotal' => $subtotal,
            'user_id' => $user_id,
            'total' => $total,
            'currency' => $currency,
            'order_at' => now(),
            'status' => 'pending',
            'bill_address_id' => $bill_address_id,
            'delivery_address_id' => $delivery_address_id,
        ]);
    }

    public function getUserOrders($userID = null, $paginate = 3)
    {
        $userID = auth_id_if_null($userID);

        $orders = $this->newQuery()
            ->where('user_id', $userID)
            ->paginate($paginate);

        foreach ($orders as $order) {
            $order->setAttribute('pay_type_name', dispatch_now(new GetPayTypeName($order->pay_type)));
            $order->setAttribute('order_at_formatted', $order->order_at->format(config('streams::datetime.date_format')));
            $order->setAttribute('total_formatted', $this->currency->format($order->total, $order->currency));
        }

        return $orders;
    }
}
