<?php namespace Visiosoft\OrdersModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;

class ApiController extends PublicController
{
    public function getUserOrders(OrderRepositoryInterface $orderRepository)
    {
        try {
            if (!$userID = request()->user_id) {
                throw new \Exception(trans('visiosoft.module.orders::message.user_id_required'));
            }

            return [
                'success' => true,
                'data' => $orderRepository->getUserOrders($userID),
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage(),
            ];
        }
    }
}