<?php namespace Visiosoft\OrdersModule\Seed;

use Illuminate\Database\Seeder;
use Visiosoft\OrdersModule\PaymentName\Contract\PaymentNameRepositoryInterface;

class PaymentNameSeeder extends Seeder
{
    private $paymentNameRepository;

    public function __construct(PaymentNameRepositoryInterface $paymentNameRepository)
    {
        $this->paymentNameRepository = $paymentNameRepository;
    }

    public function run()
    {
        $payments = [
            [
                'type' => 'order',
                'name' => 'Order',
            ],
            [
                'type' => 'pay_at_door',
                'name' => 'Cash on Delivery',
            ],
        ];

        foreach ($payments as $payment) {
            if (!$this->paymentNameRepository->findBy('payment_type', $payment['type'])) {
                $this->paymentNameRepository->create([
                    'payment_type' => $payment['type'],
                    'en' => [
                        'payment_name' => $payment['name'],
                    ]
                ]);
            }
        }
    }
}