<?php namespace Visiosoft\OrdersModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Illuminate\Events\Dispatcher;
use Visiosoft\OrdersModule\Orderdetail\Event\RefundOrder;
use Visiosoft\OrdersModule\Orderpayment\Form\OrderpaymentFormBuilder;
use Visiosoft\OrdersModule\Orderpayment\OrderpaymentModel;
use Visiosoft\OrdersModule\Orderpayment\Table\OrderpaymentTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class OrderpaymentsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param OrderpaymentTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(OrderpaymentTableBuilder $table)
    {
        $table->addButtons([
            'approve' => [
                'icon' => 'fa fa-check',
                'type' => 'success',
                'href' => 'admin/ordersPayment/approve/{entry.id}',
                'text' => function (EntryInterface $entry) {
                    if ($entry->status == "approved") {
                        return trans('visiosoft.module.orders::field.approved');
                    } else {
                        return trans('visiosoft.module.orders::field.approve');;
                    }
                },
                'disabled' => function (EntryInterface $entry) {
                    if ($entry->status == "approved") {
                        return true;
                    }
                }
            ]
        ]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param OrderpaymentFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(OrderpaymentFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param OrderpaymentFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(OrderpaymentFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function approve(Dispatcher $events, $orderPaymentId)
    {
        $orderPaymentModel = new OrderpaymentModel();
        $payment = $orderPaymentModel->getPayment($orderPaymentId);

        if ($payment->payment_reason == 'cancel') {
            $orderPaymentModel->approve($orderPaymentId);
            $user = $orderPaymentModel->getPaymentUser($orderPaymentId);

            $events->dispatch(new RefundOrder($user));
//            $user->notify(new RefundOrder($user['display_name']));/*notify*/
        } else {
            $orderPaymentModel->approve($orderPaymentId, 'seller');
//            $user->notify(new PaymentOrder($user['display_name']));/*notify*/
        }
        return back();
    }
}
