<?php namespace Visiosoft\OrdersModule\Order;

use Anomaly\UsersModule\User\UserModel;
use Illuminate\Support\Facades\Auth;

use Rinvex\Subscriptions\Models\PlanSubscription;

use Rinvex\Subscriptions\Services\Period;
use Visiosoft\BalancesModule\Balance\BalanceModel;
use Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController;
use Visiosoft\OrdersModule\Order\Contract\OrderInterface;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderEntryModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryModel;
use Visiosoft\PackagesModule\Userentry\UserentryModel;
use Visiosoft\SiteModule\Addon\AddonModel;
use Visiosoft\SiteModule\Site\Event\AddAddonSite;
use Visiosoft\SubscriptionsModule\Subscription\SubscriptionModel;
use Visiosoft\SubscriptionsModule\SubscriptionRenewRequest\SubscriptionRenewRequestModel;

class OrderModel extends OrdersOrderEntryModel implements OrderInterface
{

    public function create_orders(array $attr)
    {
        return $this->create($attr)->getId();
    }

    public function orders_total($items)
    {
        $total = 0;
        foreach ($items as $item) {
            $total += $item->total;
        }
        return $total;
    }

    public function status($status, $id)
    {
        $orderDetail_model = new OrderdetailModel();
        $order_detail = $orderDetail_model->getDetail($id);

        foreach ($order_detail as $item) {

            if ($status == 'approved') {

                $orderDetail_model->getOrder($item->id)->update(['status' => 'awaiting_tracking_number']);

                if ($item->item_type == 'doping') {

                    $doping_controller = new DopingsController();
                    $doping_controller->approve($item->item_id);

                } else if ($item->item_type == 'package') {

                    $packageEntryModel = new PackageEntryModel();
                    $userentryModel = new UserentryModel();
                    $package_model = new \Visiosoft\PackagesModule\User\UserModel();
                    $userForPackage = $package_model->newQuery()->find($item->item_id);
                    if (!is_null($userForPackage) and $userForPackage->status != "approved") {
                        $package = $package_model->status($userForPackage->id, 'approved');
                        $Packageentry = $packageEntryModel->getEntryPackage($package->package_id);
                        $userentryModel->addEntryUserArray($Packageentry, $package->id);
                    }

                } else if ($item->item_type == 'site') {

                    $addonModel = new AddonModel();
                    $addon = $addonModel->newQuery()->find($item->item_id);
                    if($addon)
                    {
                        event(new AddAddonSite($addon->subdomain, $addon->addon));
                        $addon->update([
                            'payment' => true,
                            'installed' => 'pending'
                        ]);
                    }
                } else if ($item->item_type == 'balance') {

                    $balance_model = new BalanceModel();
                    $balance_model->approve($item->item_id);

                } else if ($item->item_type == 'Subscription') {

                    $subscriptionRenew_model = new SubscriptionRenewRequestModel();

                    $is_renew_or_upgrade = $subscriptionRenew_model
                        ->whereRaw("( new_plan_id = " . $item->item_id . " OR old_plan_id = " . $item->item_id . " )")
                        ->where('created_by_id', $item->created_by_id)
                        ->where('status', '!=', 'success')
                        ->where('status', '!=', 'canceled')
                        ->orderBy('id', 'desc')
                        ->first();
                    if ($is_renew_or_upgrade) {
                        $subscription_model = new PlanSubscription();
                        $user = new \Visiosoft\SubscriptionsModule\User\UserModel();
                        $subscriptionDetails = $subscription_model->find($is_renew_or_upgrade->subscription_id);
                        $user = $user->find($item->created_by_id);

                        if ($is_renew_or_upgrade->new_plan_id == 0) {
                            //Subscription Extend
                            $subscriptionDetails = $subscription_model->find($is_renew_or_upgrade->subscription_id);
                            $subscription = $user->subscription($subscriptionDetails->slug);


                            $old_day = (strtotime($subscription->ends_at) - strtotime($subscription->starts_at)) / 86400;
                            $old_day = round($old_day, 0);

                            $expiresDate = strtotime('+' . $subscription->plan->invoice_period . ' ' . $subscription->plan->invoice_interval, strtotime(now()));
                            $expiresSumOldDate = strtotime('+' . $old_day . ' days', $expiresDate);

                            $expired_day = ($expiresSumOldDate - strtotime(now())) / 86400;
                            $expired_day = round($expired_day, 0);

                            $subscription = $subscription_model->find($subscription->id);

                            $period = new Period('day', $expired_day, '');

                            $subscription->starts_at = $period->getStartDate();
                            $subscription->ends_at = $period->getEndDate();
                            $subscription->canceled_at = null;

                            $subscription->save();

                        } else {
                            //Subscription Upgrade
                            $subscriptionDetails->update(['plan_id' => $is_renew_or_upgrade->new_plan_id]);
                            $user->subscription($subscriptionDetails->slug)->renew();
                        }
                        $is_renew_or_upgrade->update(['status' => 'success', 'order_id' => $id]);

                    } else {
                        //Buy new Subscription
                        $SubscriptionModel = new SubscriptionModel();
                        $SubscriptionModel->addPlanUser($item->item_id);
                    }
                }
            }
        }
        return $this->find($id)->update(['status' => $status]);
    }

    public function getOrder($id)
    {
        return $this->find($id);
    }

    public function findMyOrder($id)
    {
        return $this->where('user_id', Auth::id())
            ->where('id', $id)->first();
    }

    public function getOrderUser($uid)
    {
        return UserModel::query()->find($uid);
    }

    public function getLastOrderByUser()
    {
        return OrderModel::query()
            ->where('user_id', Auth::id())
            ->orderByDesc('id')
            ->first();
    }

    public function listMyOrders($userID = null)
    {
        $userID = $userID ?: \auth()->id();

        return OrderModel::query()
            ->where('user_id', $userID)
            ->orderByDesc('id')->paginate(setting_value('streams::per_page'));
    }

}
