<?php namespace Visiosoft\OrdersModule\OrderStatus;

use Visiosoft\OrdersModule\OrderStatus\Contract\OrderStatusRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class OrderStatusRepository extends EntryRepository implements OrderStatusRepositoryInterface
{
    protected $model;

    public function __construct(OrderStatusModel $model)
    {
        $this->model = $model;
    }

    public function GetOrderStatusHistory($id) {
    	return $this->newQuery()->where('order_id', $id)->orderBy('created_at', 'desc')->get();
    }
}
