<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleOrdersCreatePaymentNameStream extends Migration
{
    protected $delete = true;

    protected $stream = [
        'slug' => 'payment_name',
        'title_column' => 'payment_type',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'payment_name' => 'anomaly.field_type.text',
        "payment_type" => 'anomaly.field_type.slug'
    ];

    protected $assignments = [
        'payment_name' => [
            'translatable' => true,
            'required' => true,
        ],
        'payment_type' => [
            'unique' => true,
            'required' => true,
        ],
    ];

}
