<?php namespace Visiosoft\OrdersModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\OrdersModule\Order\Form\OrderFormBuilder;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Order\Table\OrderTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class OrderController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param OrderTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(OrderTableBuilder $table)
    {
        $table->setColumns(['user','pay_type','total' => [
            'value' => 'entry.total.currency',
        ],'order_at','status' => ['value' =>trans('visiosoft.module.orders::field.{entry.status}')]]);

            $table->addButtons([
                'approve' => [
                    'icon' => 'fa fa-check',
                    'type' => 'success',
                    'href' => 'admin/orders/approve/{entry.id}',
                    'text' => function (EntryInterface $entry) {
                        if($entry->status == "approved")
                        {
                            return trans('visiosoft.module.orders::field.approved');
                        } else {
                            return trans('visiosoft.module.orders::field.approve');;
                        }
                    },
                    'disabled' => function (EntryInterface $entry) {
                        if($entry->status == "approved")
                        {
                            return true;
                        }
                    }
                ]
            ]);

        $table->addButtons(['view' => [
            'href' => 'admin/orders/orderdetail?filter_order={entry.id}'
        ]]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param OrderFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(OrderFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param OrderFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(OrderFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function approve($id) {
        $thisModel = new OrderModel();
        $thisModel->status('approved',$id);
        return back();
    }
}
