<?php namespace Visiosoft\OrdersModule\RefundRequest\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\OptionConfiguration\Contract\OptionConfigurationRepositoryInterface;

class RefundRequestTableColumns
{
    public function handle(RefundRequestTableBuilder $builder)
    {
        $builder->setColumns([
            'id' => 'entry.id',
            'user' => [
                'wrapper' => '<a href="/admin/users/edit/{value.id}">{value.name}</a>',
                'value' => [
                    'name' => 'entry.order_detail.order.user.name()',
                    'id' => 'entry.user.id'
                ],
            ],
            'item_id' => [
                'value' => function (EntryInterface $entry,
                                     AdvRepositoryInterface $repository,
                                     OptionConfigurationRepositoryInterface $optionConfigurationRepository) {
                    if ($entry->order_detail->item_type == 'adv') {
                        $adv = $repository->getListItemAdv($entry->order_detail->item_id);
                        if ($adv) {
                            return '<a href="' . route("adv_detail", [$adv->id]) . '">' . $adv->id . '</a>'.
                                ' | ' . '<a href="' . route("adv_detail", [$adv->id]) . '">' . $adv->name . '</a>';
                        }
                        return trans('module::message.ad_not_found');
                    } else if ($entry->order_detail->item_type == 'ads-configuration') {
                        if ($configuration = $optionConfigurationRepository->find($entry->order_detail->item_id)) {
                            return $configuration->getName();
                        }
                    }
                }
            ],
            'refund_request_message',
	        'refund_status',
        ]);
    }
}
