<?php namespace Visiosoft\OrdersModule\Order;

use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;

class OrderRepository extends EntryRepository implements OrderRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var OrderModel
     */
    protected $model;
    protected $orderdetail;

    /**
     * Create a new OrderRepository instance.
     *
     * @param OrderModel $model
     */
    public function __construct(OrderModel $model, OrderdetailRepositoryInterface $orderdetail)
    {
        $this->model = $model;
        $this->orderdetail = $orderdetail;
    }

    public function approveOrder($orderId)
    {
        $this->model->setStatus('approved', $orderId);
    }

    public function rejectOrder($orderId)
    {
        $this->find($orderId)->update(['status' => 'rejected']);
    }

    public function createOrder($user_id, $total, $subtotal, $currency, $pay_type = '$pay_type')
    {
        return $this->create([
            'pay_type' => $pay_type,
            'subtotal' => $subtotal,
            'user_id' => $user_id,
            'total' => $total,
            'currency' => $currency,
            'order_at' => now(),
            'status' => 'pending',
        ]);
    }
}
