<?php namespace Visiosoft\OrdersModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Illuminate\Events\Dispatcher;
use Visiosoft\OrdersModule\Order\Form\OrderFormBuilder;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Order\Table\OrderTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\OrdersModule\Orderdetail\Event\PaymentOrder;

class OrderController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param OrderTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(OrderTableBuilder $table)
    {
        $table->setColumns([
            'id' => 'entry.id',
            'user',
            'pay_type',
            'total' => [
                'value' => 'entry.total.currency',
            ],
            'order_at',
            'status' => [
                'value' =>trans('visiosoft.module.orders::field.{entry.status}')
            ]
        ]);

        $table->addButtons(['view' => [
            'href' => 'admin/orders/orderdetail?filter_order={entry.id}'
        ]]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param OrderFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(OrderFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param OrderFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(OrderFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
