<?php namespace Visiosoft\OrdersModule\Http\Controller\Admin;

use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Form\OrderdetailFormBuilder;
use Visiosoft\OrdersModule\Orderdetail\Table\OrderdetailTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class OrderdetailController extends AdminController
{
    public function index(OrderdetailTableBuilder $table)
    {
        return $table->render();
    }

    public function create(OrderdetailFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(OrderdetailFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function print(OrderdetailRepositoryInterface $orderdetailRepository, $id)
    {
        $orderDetail = $orderdetailRepository->find($id);

        if (!$orderDetail) {
            abort(404);
        }

        return view('visiosoft.module.orders::admin/order-detail/print')->with('orderDetail', $orderDetail);
    }
}
