<?php namespace Visiosoft\OrdersModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\OrdersModule\Orderpayment\Contract\OrderpaymentRepositoryInterface;
use Visiosoft\OrdersModule\Orderpayment\OrderpaymentRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderpaymentsEntryModel;
use Visiosoft\OrdersModule\Orderpayment\OrderpaymentModel;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderdetailEntryModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Order\OrderRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderEntryModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Illuminate\Routing\Router;

class OrdersModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        OrdersModulePlugin::class
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'sale' => [
            'as' => 'orders::sale',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@sale',
        ],
        'sale/detail/{id}' => [
            'as' => 'orders::sale_detail',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@saleDetail',
        ],
        'sale/report' => [
            'as' => 'orders::sale_report',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@reportSales',
        ],
        'sale/addTrackingNumber' => [
            'as' => 'orders::sale_addTrackingNumber',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@addTrackingNumber',
        ],
        'purchase' => [
            'as' => 'orders::purchase',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@purchase',
        ],

        'purchase/delivered/{id}' => [
            'as' => 'orders::purchase_delivered',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@orderDelivered',
        ],

        'purchase/not-delivered/{id}' => [
            'as' => 'orders::purchase_not_delivered',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@orderNotDelivered',
        ],


        'purchase/detail/{id}' => [
            'as' => 'orders::purchase_detail',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@purchaseDetail',
        ],
        'admin/orders/orderpayments' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@index',
        'admin/orders/orderpayments/create' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@create',
        'admin/orders/orderpayments/edit/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@edit',
        'admin/orders/orderdetail' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@index',
        'admin/orders/orderdetail/create' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@create',
        'admin/orders/orderdetail/edit/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@edit',
        'admin/orders' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@index',
        'admin/orders/create' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@create',
        'admin/orders/edit/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@edit',
        'admin/orders/approve/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@approve',
        'admin/ordersPayment/approve/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@approve',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\OrdersModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\OrdersModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\OrdersModule\Event\ExampleEvent::class => [
        //    Visiosoft\OrdersModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\OrdersModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        OrdersOrderpaymentsEntryModel::class => OrderpaymentModel::class,
        OrdersOrderdetailEntryModel::class => OrderdetailModel::class,
        OrdersOrderEntryModel::class => OrderModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        OrderpaymentRepositoryInterface::class => OrderpaymentRepository::class,
        OrderdetailRepositoryInterface::class => OrderdetailRepository::class,
        OrderRepositoryInterface::class => OrderRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
