<?php namespace Visiosoft\OrdersModule\Order\Table;

use Anomaly\Streams\Platform\Ui\Table\Table;
use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\OrdersModule\Order\Contract\OrderInterface;
use Visiosoft\OrdersModule\Order\Table\Actions\Approve;
use Visiosoft\OrdersModule\Order\Table\Actions\Reject;

class OrderTableBuilder extends TableBuilder
{
    protected $buttons;

    public function __construct(Table $table)
    {
        parent::__construct($table);

        $this->buttons = $this->addButtonsButtons();
    }

    protected $actions = [
        'approve' => [
            'handler' => Approve::class,
            'class' => 'btn btn-success'
        ],
        'reject' => [
            'handler' => Reject::class,
            'class' => 'btn btn-danger'
        ],
    ];

    protected $options = [
        'order_by' => [
            'id' => 'DESC',
        ],
    ];

    protected $assets = [
        'scripts.js' => [
            'visiosoft.module.advs::js/admin/filter-user.js',
        ],
        'styles.css' => [
            'visiosoft.module.advs::css/admin/filter-user.css',
        ],
    ];

    private function addButtonsButtons()
    {
        return [
            'approve_order' => [
                'href' => function (OrderInterface $entry) {
                    $status = ($entry->status != 'approved') ? 'approve' : 'reject';
                    return "/admin/orders/" . $status . "/" . $entry->getId();
                },
                'class' => function (OrderInterface $entry) {
                    return $entry->status == 'approved' ? 'btn btn-danger' : 'btn btn-success';
                },
                'text' => function (OrderInterface $entry) {
                    return $entry->status == 'approved'
                        ? trans('visiosoft.module.orders::field.reject')
                        : trans('visiosoft.module.orders::field.approve');
                },
            ],
            'view' => [
                'href' => 'admin/orders/orderdetail?filter_order={entry.id}'
            ]
        ];
    }
}
