<?php namespace Visiosoft\OrdersModule\RefundRequest;

use Visiosoft\OrdersModule\RefundRequest\Contract\RefundRequestRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class RefundRequestRepository extends EntryRepository implements RefundRequestRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var RefundRequestModel
     */
    protected $model;

    /**
     * Create a new RefundRequestRepository instance.
     *
     * @param RefundRequestModel $model
     */
    public function __construct(RefundRequestModel $model)
    {
        $this->model = $model;
    }

    public function createRefundRequest($detail_id, $refund_request_message)
    {
        return $this->create([
            'order_detail' => $detail_id,
            'refund_request_message' => $refund_request_message,
            'refund_status' => 'pending',
        ]);
    }

    public function findByDetail($detail_id)
    {
        return $this->newQuery()->where('order_detail_id', $detail_id)
            ->orderByDesc('id')
            ->first();
    }
}
