<?php namespace Visiosoft\OrdersModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;

class ReportController extends AdminController
{
    protected $orderRepository;
    protected $orderdetailRepository;

    public function __construct(
        OrderRepositoryInterface $orderRepository,
        OrderdetailRepositoryInterface $orderdetailRepository
    )
    {
        parent::__construct();
        $this->orderRepository = $orderRepository;
        $this->orderdetailRepository = $orderdetailRepository;
    }

    public function city()
    {
        return $this->orderRepository->getOrdersReportByCity();
    }

    public function classified()
    {
        return $this->orderdetailRepository->getOrdersReportByClassified();
    }

    public function category()
    {
        return $this->orderdetailRepository->getOrdersReportByCategory();
    }

    public function payment()
    {
        return $this->orderRepository->getOrdersReportByPaymentType();
    }

    public function member()
    {
        return $this->orderRepository->getOrdersReportByMember();
    }
}
